function [] = sensitivity(units,ro,ros,g,figure_counter,Hi_slope,Lo_slope,new_geo,new_geo_p,...
    c_r,f_r,c_p,f_p,D50,func_choice,n_chunks,final_rows,n_ranges,...
    firstCol,eco_func_per_chunk,matrix,spaces,julian_day,Q,tau_star,...
    Q_star,eco_names,n_eco_func,start_day,end_day,D50_choice,n_gs,gs_range,...
    c_r_H,f_r_H,w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r,...
    c_p_H,f_p_H,w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p,Hi_slope_p,Lo_slope_p,...
    tau_thresh,S,dhdx,nonuniform,unsteady,julian_test)

sens_choice = 0;

while sens_choice ~= 2
    disp(' ')
    disp('<<<<    Sensitivity Study    >>>>')
    disp(' ')
    disp('Would you like to change any inputs for the purposes of a sensitivity study?')
    disp('1. Yes')
    disp('2. No')
    disp(' ')
    
    sens_choice = input('Please enter either 1 or 2:  ');
    disp(' ')
    
    switch sens_choice
%% CASE 1 sensitivity is desired        
        case 1  %Want sensitivity study
            
            opt = 0;
            
            while opt ~= 9
                disp(' ')
                disp('What inputs would you like to change?')
                disp(' ')
                disp('1. Slope')
                disp('2. Manning''s ''c'' for riffle')
                disp('3. Manning''s ''f'' for riffle')
                disp('4. Riffle Geometry (changes Manning''s ''c'' and ''f'')')
                disp('5. Mean Grain Size (D50)')
                disp('6. Hydrograph')
                disp('7. Add/Remove/Change nonuniform shear terms')
                disp('8. Functionality Table')
                disp('9. I do not want to change anything else.')
                disp('** This menu will prompt as long as 9 is not entered. **')
                disp(' ')
                opt = input('Please enter 1 through 9:  ');
                disp(' ')

                switch opt
%% Change slope                    
                    case 1
                        [Hi_slope Lo_slope] = get_slope;
                        inc = 100;
                        for i=1:inc
                            S(i) = Lo_slope + ((Hi_slope-Lo_slope)/(inc-1))*(i-1);
                        end
%% Change c                        
                    case 2

                        if units == 1
                            disp('** IMPORTANT **')
                            disp('Please ensure your calculations of ''c'' are in Metric units, as you previously incidated.')
                        else
                            disp('** IMPORTANT **')
                            disp('Please ensure your calculations of ''c'' are in English units, as you previously incidated.')
                        end

                        c_r = input('Please enter the value of c (where R=cQ^f):  ');
                        disp(' ')

                        while c_r <= 0
                            
                            if c_r <= 0
                                disp(' ')
                                disp('Please enter positive values for c.')
                                disp(' ')
                            end %of if

                            c_r = input('Please enter the value of c (where R=cQ^f):  ');
                            disp(' ')

                        end %of while
%% Change f                        
                    case 3

                        if units == 1
                            disp('** IMPORTANT **')
                            disp('Please ensure your calculations of ''f'' are in Metric units, as you previously incidated.')
                        else
                            disp('** IMPORTANT **')
                            disp('Please ensure your calculations of ''f'' are in English units, as you previously incidated.')
                        end

                        f_r = input('Please enter the value of f (where R=cQ^f):  ');
                        disp(' ')

                        while f_r <= 0
                            
                            if f_r <= 0
                                disp(' ')
                                disp('Please enter positive values for f.')
                                disp(' ')
                            end %of if

                            f_r = input('Please enter the value of f (where R=cQ^f):  ');
                            disp(' ')

                        end %of while
%% Change riffle xs geo                        
                    case 4
                        if units == 1
                            disp(' ')
                            disp('Please copy the riffle''s cross-sectional geometry (in meters) into the folder in which this program runs.')
                            disp(' ')
                        else
                            disp(' ')
                            disp('Please copy the riffle''s cross-sectional geometry (in feet) into the folder in which this program runs.')
                            disp(' ')
                        end
                        xs_string = input('Please input the name of the text file, including the .txt extension:  ','s');
                        disp(' ')
                        xs_geo=load(xs_string);

                        %Get the inc_p
                        inc = 0;
                        while inc <= 0

                            %Check units
                            if units == 1
                                inc = input('Please enter the depth increment (in meters) for the Manning''s calcualtion:  ');
                            else
                                inc = input('Please enter the depth increment (in feet) for the Manning''s calculation:  ');
                            end

                            if inc <= 0
                                disp(' ')
                                disp('Please input a positive value.')
                            end % if
                        end % while

                        %Get the mannings n
                        n = 0;
                        while n <= 0

                            disp(' ')
                            n = input('Please input the value of the Mannings n:  ');

                            if n <= 0
                                disp(' ')
                                disp('Please input a positive value.')
                            end % if

                        end % while

                        %Call the simpler mannings function
                        [c_r,f_r,new_geo,figure_counter,c_r_H,f_r_H,...
                            w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r] = ...
                            Mannings(xs_geo,n,Hi_slope,Lo_slope,inc,figure_counter,units);
%% Change D50                        
                    case 5
                        [D50,D50_choice,n_gs,gs_range] = get_D50(units);

%% Change flow data
                    case 6
                        disp(' ')
                        disp('<<<<   Daily Flow Data   >>>>')
                        disp(' ')
                        disp('Please copy your flow data into the folder in which this program runs.')
                        disp('The flow data should contain four columns.')
                        disp('The first 3 columns are month, day, and year respectively, beginning with Oct 1.')
                        disp('The last column is the flow rate, Q.')
                        disp('The analysis of multiple water years is possible.')
                        disp('Simply add the same data for a new year just below the previous year''s data.')
                        disp('The program will automatically detect the number of years.')
                        disp('Please ensure the years are in chronologial order.')
                        disp(' ')

                        if units == 1
                            disp('Since you are in Metric units, make sure the value of Q is in m^3/s.')
                            disp(' ')
                        else
                            disp('Since you are in English units, make sure the value of Q is in ft^3/s.')
                            disp(' ')
                        end

                        flow_string = input('Please enter the name of the flow data file, including the .txt extension:  ','s');
                        flow_data = load(flow_string);
                        Q = flow_data(:,4);
                        julian_day = 1:1:length(Q);

                        %Find the number of years in the flow data
                        years_vector = flow_data(:,3);

                        keep_going = 1;
                        test_year = years_vector(1);
                        i = 1;
                        while keep_going
                            year_holder = find(years_vector > test_year);

                            if isempty(year_holder)
                                keep_going = 0;
                            else
                                water_years(i) = years_vector(year_holder(1));

                                test_year = water_years(i);
                                i = i + 1;
                                keep_going = 1;
                            end %if

                        end %while

                        n_water_years = length(water_years);

                        for i = 1:n_water_years

                            % General case
                            if mod(water_years(i),4) == 0
                                is_leap_year(i) = 1;
                            else
                                is_leap_year(i) = 0;
                            end %if

                            % Case of centurial years: only centurial years divisible by 400 are
                            % leap years
                            if mod(water_years(i),100) == 0
                                if mod(water_years(i),400) == 0
                                    is_leap_year(i) = 1;
                                else
                                    is_leap_year(i) = 0;
                                end %inner if
                            end %outer if

                        end %i loop

                        % Get a vector to test the julian day
                        julian_test = [];

                        if n_water_years > 1

                            for k = 1:n_water_years - 1
                                p = length(find(years_vector == water_years(k)));
                                julian_test = [julian_test,1:1:p];
                            end

                            k = n_water_years;
                            julian_test = [julian_test,1:1:(365 + is_leap_year(k))];
                        else
                            julian_test = 1:1:(365 + is_leap_year);
                        end

%% Change terms
                    case 7
                        [dhdx, nonuniform, unsteady, new_geo_p, figure_counter, new_geo, c_p, f_p,...
                            c_p_H,f_p_H,w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p,Hi_slope_p,Lo_slope_p...
                            c_r_H,f_r_H,w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r] =...
                            change_tau_terms(Q,units,g,c_r,f_r,new_geo,figure_counter,c_r_H,f_r_H,Hi_slope,Lo_slope,...
                            w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r,dhdx,nonuniform,unsteady);
                        
%% Change func table                        
                    case 8
                        [tau_thresh, matrix, n_eco_func, start_day, end_day, ...
                            n_ranges, firstCol, eco_names, spaces, n_chunks, eco_func_per_chunk, ...
                            final_rows, func_choice] = get_func(julian_day);

                        %% No more changes
                    case 9
                        continue
                    otherwise
                        disp(' ')
                        disp('Please enter a number 1 through 9.')
                        disp(' ')

                end %end of switch on the input options

            end %end of while for input option change

%% do the calculations now.  start with asking about visuals
            [figure_counter] = visuals(new_geo, Q, units, n_ranges, n_eco_func,...
                matrix, firstCol, start_day, end_day, eco_names, spaces, julian_day,...
                figure_counter, n_chunks, eco_func_per_chunk, final_rows, func_choice, ...
                new_geo_p);

%% compute the shear
            Qmax = max(Q);
            Qmin = min(Q);

            dQtest = ((Qmax-Qmin)/(length(S)-1));

            for j=1:length(S)
                Qtest(j) = Qmin + dQtest*(j-1);
                Qtest(j) = Roundoff(Qtest(j),10);
            end

            % This double loop calculates the shear stress and flow
            for i=1:length(Q)

                for j = 1:length(S)

                    if (Q(i) >= Qtest(j)) && (Q(i) < (Qtest(j)+dQtest))
                        tau(i) = ro*g*(c_r*Q(i)^f_r)*(S(j) - dhdx(i) - nonuniform(i) - unsteady(i));
                        tau_star(i) = tau(i)/(g*(ros - ro)*D50);
                        break
                    end  % if

                end % j loop

                Q_star(i) = Q(i)/(sqrt(g*D50)*D50^2);

            end % i loop
            
%% now do outputs
            [figure_counter,GMF,real_F,total_days_GMF,total_days_F,t_store,Q_store,tau_is_pos] ...
                = outputs(tau_thresh, n_ranges, n_eco_func, eco_names, tau_star, Q_star,...
                matrix, start_day, end_day, julian_day, figure_counter, julian_test,...
                n_chunks, eco_func_per_chunk, units);
            
%% finally, write the output file
            writing_outputs(units,Hi_slope,Lo_slope,new_geo,new_geo_p,...
                c_r,f_r,c_p,f_p,D50,func_choice,n_chunks,final_rows,n_ranges,...
                firstCol,eco_func_per_chunk,matrix,spaces,julian_day,Q,tau_star,...
                Q_star,eco_names,GMF,real_F,n_eco_func,total_days_GMF,total_days_F,...
                start_day,end_day,D50_choice,n_gs,gs_range,...
                c_r_H,f_r_H,w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r,...
                c_p_H,f_p_H,w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p,Hi_slope_p,Lo_slope_p,...
                t_store,Q_store,tau_thresh,tau_is_pos)


%% CASE 2 if no sensitivity is desired
        case 2  %Do not want sensitivity study
            continue
        otherwise
            disp(' ')
            disp('Please enter only 1 or 2.')
            disp(' ')
    end %end of sens_choice switch statement

end %end of sens_choice while loop